 ; Ŀ
 ;   Bindo - bind all xrefs, ditch the xref layer names.                   
 ;   Bindt - bind all xrefs, don't ditch the xref layer names.             
 ;   Bindx - bind and explode all xrefs, ditch the xref layer names.       
 ;   Copyright 2007, 2008 by Rocket Software Ltd.                          
 ;   The cruise missile is just a further development of lawn darts.       
 ; 

 ; Ŀ
 ;   Contx - Find all referenced xref definitions in the block tables.     
 ;   Takes no arguments.                                                   
 ;   Returns a list of lists: ((Blockname Filename)...)                    
 ; 
 (DEFUN CONTX (/ rew bldat sevnt namlst)
  (setq rew t)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq sevnt (cdr (assoc 70 bldat)))
         (if (and (= 4 (logand 4 sevnt)) (= 32 (logand 32 sevnt)))
             (setq namlst (append namlst (list (list (cdr (assoc 2 bldat))
                                                   (cdr (assoc 1 bldat))))))))
 namlst)
 ; Ŀ
 ;   Contx end.                                                            
 ; 

 ; Ŀ
 ;   Bindx - bind and explode all xrefs.                                   
 ; 
 (DEFUN C:BINDX (/ ss sub xlst enam num)
  (setvar "cmdecho" 0)
  (setvar "bindtype" 1)
  (setq xlst (contx))
  (while (setq sub (caar xlst))
         (setq sub (strcase sub))
         (setq xlst (cdr xlst))
         (command "-xref" "bind" sub)
         (if (setq ss (ssget "x" (list (cons 2 sub))))
             (progn
                  (setq num 0)
                  (while (setq enam (ssname ss num))
                         (setq num (1+ num))
                         (command ".explode" enam)))))
 (princ))

 ; Ŀ
 ;   Bindt.                                                                
 ; 
 (DEFUN C:BINDT ()
  (setvar "cmdecho" 0)
  (setvar "bindtype" 0)
  (command "-xref" "bind" "*")
 (princ))

 ; Ŀ
 ;   Bindo.                                                                
 ; 
 (DEFUN C:BINDO ()
  (setvar "cmdecho" 0)
  (setvar "bindtype" 1)
  (command "-xref" "bind" "*")
 (princ))

(write-line "\nC:BINDO/C:BINDT/C:BINDX")
(princ)